package com.richard_gauthier.CompteurAiguille
{
	import com.richard_gauthier.TexteEnBitmap.TexteEnBitmap;
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	
	/**
	 * ...
	 * @author rg
	 */
	public class CompteurAiguille extends Sprite
	{
		[Embed(source="bar8.png")]
		private var bar1C:Class;
		private var bar1:Bitmap = new bar1C;
		
		[Embed(source="bar9.png")]
		private var bar9C:Class;
		private var bar9:Bitmap = new bar9C;
		
		private var bar1S:Sprite = new Sprite();
		private var bar2S:Sprite = new Sprite();
		
		private var leTexte:TextField = new TextField();
		public var couleurG:uint = 0xffffff;
		
		private var miniG:Number = 0;
		private var maxiG:Number = 100;
		
		private var transEnbitmap:TexteEnBitmap = new TexteEnBitmap();
		private var monBitmap:Bitmap;
		
		public function CompteurAiguille(leTitre:String = "Le Titre", unite:String = "Unité", mini:Number = 0, maxi:Number = 100, couleur:uint = 0xffffff)
		{
			if (mini < maxi)
			{
				maxiG = maxi;
				miniG = mini;
			}
			
			couleurG = couleur;
			
			bar1S.addChild(bar1);
			addChild(bar1S);
			
			bar9.height = bar1S.height + 8;
			bar9.width = bar1S.width;
			
			addChild(bar9);
			
			var ecart:Number = (maxiG - miniG) / 10;
			
			var angle:Number;
			var angle1:Number;
			
			for (var i:int = 0; i < 11; i++)
			{
				angle = (225 - i * 270 / 10) * Math.PI / 180;
				angle1 = (-135 + i * 270 / 10);
				label("" + (miniG + ecart * i), 130 * Math.cos(angle) + bar1S.width / 2, -130 * Math.sin(angle) + 199, 4, angle1);
				
			}
			
			//Placer l'unité
			label(unite, bar1S.width / 2, 340, 6);
			//Placer le titre
			label(leTitre, bar1.width / 2, 160, 0);
			
			var formatTexte:TextFormat = new TextFormat();
			formatTexte.font = "tahoma";
			formatTexte.size = 25;
			//formatTexte.bold = true;
			formatTexte.color = couleur;
			formatTexte.align = TextFormatAlign.CENTER;
			
			leTexte.width = 60;
			leTexte.height = 30;
			//leTexte.autoSize = TextFieldAutoSize.CENTER;
			leTexte.defaultTextFormat = formatTexte;
			leTexte.text = "1000";
			leTexte.x = bar1S.width / 2 - leTexte.width / 2;
			leTexte.y = 273;
			addChild(leTexte);
			setValue(miniG);
			
			addChild(bar2S);
		
		}
		
		public function setValue(value:Number):void
		{
			var longueur:Number = 125;
			leTexte.text = "" + value;
			
			if (value < miniG)
				value = 0;
			else if (value > maxiG)
				value = 268;
			else
			{
				if (miniG >= 0)
					value = 268 / (maxiG - miniG) * value;
				else if (miniG < 0)
					value = 268 / (maxiG - miniG) * (value - miniG);
				
			}
			
			value = (224 - value) * Math.PI / 180;
			bar2S.graphics.clear();
			bar2S.graphics.lineStyle(5, 0xff0000);
			bar2S.graphics.moveTo(bar1S.width / 2, 199);
			bar2S.graphics.lineTo(longueur * Math.cos(value) + bar1S.width / 2, -longueur * Math.sin(value) + 203);
		
		}
		
		private function label(texte:String, posiX:Number, posiY:Number, NbCaracteres:int = -1, angle:Number = 0):void
		{
			if (NbCaracteres > 0)
				if (texte.length > NbCaracteres)
					texte = texte.substr(0, NbCaracteres);
			
			var monSprite:Sprite = new Sprite();
			monBitmap = new Bitmap(transEnbitmap.transformerTexteEnBitmap(texte, couleurG));
			monBitmap.x = -monBitmap.width / 2;
			monBitmap.y = -monBitmap.height;
			
			monSprite.addChild(monBitmap);
			monSprite.x = posiX;
			monSprite.y = posiY;
			//monSprite.graphics.lineStyle(5, 0xff0000);
			//monSprite.graphics.moveTo(0,0);
			//monSprite.graphics.lineTo(0, 20);
			
			monSprite.rotation = angle;
			monBitmap.cacheAsBitmap = true;
			
			addChild(monSprite);
		
			//leTexteMesure.addEventListener(MouseEvent.CLICK,mouseClick)
		
		}
	
	}

}